﻿/*
 * COPYRIGHT Wayne Watson 2016
 */

using System;
using System.IO;
using System.Text;

namespace romcheck
{
    class BrzRomCheck
    {
        static int EXP_LENGTH = 1310720;
        static int ALT_LENGTH = 1277952;
        static int LOCATION_1 = 32768; // 8000h
        static int LOCATION_2 = 1048576; // 100000h
        static void Main(string[] args)
        {
            Console.WriteLine();
            if (args == null || args.Length == 0)
            {
                CheckDirectory(new DirectoryInfo(System.Environment.CurrentDirectory));
            }
            else if (args[0] == "/?" || args[0] == "-?")
            {
                Console.Out.WriteLine("Usage: romcheck.exe \"Directory/Filename\" or Analyse Current Directory.");
            }
            else if (Directory.Exists(args[0]))
            {
                try
                {
                    DirectoryInfo dir = new DirectoryInfo(args[0]);
                    CheckDirectory(dir);
                }
                catch (Exception e)
                {
                    Console.Error.WriteLine(e.Message);
                }
            }
            else if (File.Exists(args[0]))
            {
                try
                {
                    FileInfo file = new FileInfo(args[0]);
                    CheckROM(file);
                }
                catch (Exception e)
                {
                    Console.Error.WriteLine(e.Message);
                }
            }
            else
            {
                Console.Error.WriteLine("Path does not exist.");
            }
            Console.WriteLine(Environment.NewLine + "Press any key to continue.");
            Console.ReadKey();
        }

        static void CheckDirectory(DirectoryInfo dir)
        {
            foreach (FileInfo file in dir.GetFiles())
            {
                if (file.Extension.ToLower() == "bin" || file.Extension.ToLower() == "hex")
                    CheckROM(file);
            }
        }

        static void CheckROM(FileInfo file)
        {
            int Offset = 0;
            Byte[] bytes1 = new Byte[8];
            Byte[] bytes2 = new Byte[8];
            Byte[] bytes3 = new Byte[8];

            Console.Out.WriteLine("Name:\t" + file.Name + Environment.NewLine + "Size:\t" + file.Length.ToString("X") + "h");
            
            if (file.Length == ALT_LENGTH)
            {
                Offset = EXP_LENGTH - ALT_LENGTH;
                Console.Out.WriteLine("Error:\tMissing first " + Offset.ToString("X") + "h bytes");
            }
            else if (file.Length != EXP_LENGTH)
            {
                Console.Out.WriteLine("Error:\tIncorrect Size / Not a ROM" + Environment.NewLine);
                return;
            }

            FileStream stream = file.OpenRead();
            stream.Position = LOCATION_1 - Offset;
            stream.Read(bytes1, 0, 8);
            stream.Position = LOCATION_2 - Offset;
            stream.Read(bytes2, 0, 8);

            while (!Encoding.ASCII.GetString(bytes3).StartsWith("ZA1J") && stream.Position < stream.Length)
            {
                stream.Position -= 7;
                stream.Read(bytes3, 0, 8);
            }
            long Location3 = stream.Position;
            stream.Close();

            string calcode1 = Encoding.ASCII.GetString(bytes1);
            string calcode2 = Encoding.ASCII.GetString(bytes2);
            string calcode3 = Encoding.ASCII.GetString(bytes3);

            Console.Out.WriteLine((LOCATION_1 - Offset).ToString("X") + ":\t" + calcode1 + " (suggested calibration code)");
            Console.Out.WriteLine((LOCATION_2 - Offset).ToString("X") + ":\t" + calcode2);
            Console.Out.WriteLine(Location3.ToString("X") + ":\t" + calcode3 + " (actual calibration code)");
            if (calcode1 == calcode3)
                Console.Out.WriteLine("\tThis is a genuine " + calcode3 + " ROM.");
            else
                Console.Out.WriteLine("\tThis is a " + calcode3 + " ROM, hacked to appear as " + calcode1 + " for OFT or Ecutek." + Environment.NewLine + "\tPlease find a genuine " + calcode3 + " ROM to flash if using tactrix.");
            Console.Out.WriteLine();
        }
    }
}
